/*---------------------------------------------------
   在OLED上顯示DHT22的溫溼度
    2024/04/23
-----------------------------------------------------*/
#include "sys.h"
#include "oled.h"
#include "gui.h"
//#include "test.h"
#include <stdio.h>
#include <stdlib.h>
#include <String.h>
#include <absacc.h>
#include <intrins.h>

//8255 IC Address 直接指定
#define PA XBYTE[0x8000]   //8255 port A
#define PB XBYTE[0x8001]   //8255 port B
#define PC XBYTE[0x8002]   //8255 port C
#define CR XBYTE[0x8003]   //8255 Control word register

sbit DHT22 = P1^3;   //DHT22在P1.3

//========= DHT22 Functions ===============================
void delay_us(unsigned int us) {
    while (us--);
}

void delay_ms(unsigned int ms) {
    while (ms--) {
        delay_us(1000);
    }
}

void timer_delay20ms()		/* Timer0 delay function */
{
	TMOD = 0x01;
	TH0 = 0xB8;		/* Load higher 8-bit in TH0 */
	TL0 = 0x0C;		/* Load lower 8-bit in TL0 */
	TR0 = 1;		/* Start timer0 */
	while(TF0 == 0);	/* Wait until timer0 flag set */
	TR0 = 0;		/* Stop timer0 */
	TF0 = 0;		/* Clear timer0 flag */
}

void timer_delay30us()		/* Timer0 delay function */
{
	TMOD = 0x01;		/* Timer0 mode1 (16-bit timer mode) */
	TH0 = 0xFF;		/* Load higher 8-bit in TH0 */
	TL0 = 0xF1;		/* Load lower 8-bit in TL0 */
	TR0 = 1;		/* Start timer0 */
	while(TF0 == 0);	/* Wait until timer0 flag set */
	TR0 = 0;		/* Stop timer0 */
	TF0 = 0;		/* Clear timer0 flag */
}

void Request()			/* Microcontroller send request */
{
	DHT22 = 0;		/* set to low pin */
	timer_delay20ms();	/* wait for 20ms */
	DHT22 = 1;		/* set to high pin */
}

void Response()			/* Receive response from DHT11 */
{
  while(DHT22 == 1);
	while(DHT22 == 0);
	while(DHT22 == 1);
}


unsigned char DHT22_receive() {
    unsigned char i, dat = 0;
    for (i = 0; i < 8; i++) {
        while (!DHT22);
        //delay_us(40);
        timer_delay30us();
        if (DHT22) {
            dat = (dat << 1) | 0x01;
            while (DHT22);
        } else {
            dat = dat << 1;
        }
    }
    return dat;
}

//============ main ==========================================
void main(void)
{	       
    xdata unsigned char humidity_high, humidity_low, 
                  temperature_high, temperature_low,
                  check_sum, sum;
    xdata int T, H;
    
	  OLED_Init();			         
	  OLED_Clear(0);             
    GUI_ShowString(50,0,"DHT22",16,1);

    CR = 0x80;     // initial 8255, set all port for output 
    PA = 0xFF;     //Turn OFF all LED
    PB = 0xFF;
    PC = 0xFF;
    
    while(1)
    {
      PA = 0xFE;  //每次讀取DHT22時點亮一次PA0的LED
      delay_ms(10);
      Request();	// send start pulse 
		  Response();	// receive response 
      
      humidity_high = DHT22_receive();
      humidity_low = DHT22_receive();
      temperature_high = DHT22_receive();
      temperature_low = DHT22_receive();
      check_sum = DHT22_receive();
      
      H = (humidity_high <<8) + humidity_low;
      T = (temperature_high << 8) + temperature_low;
      
      sum = humidity_high + humidity_low + temperature_high + temperature_low;
      if (sum == check_sum)   //如果溫度和濕度數據傳輸正確
      {  
        GUI_ShowString(0,2,"Temp:",8,1);   //顯示溫度
        GUI_ShowNum(40,2,T/10,2,8,1);
        GUI_ShowString(54,2,".",8,1); 
        GUI_ShowNum(61,2,T%10,1,8,1);
        GUI_ShowString(72,2,"C",8,1);
        
        GUI_ShowString(0,3,"Humi:",8,1);    //顯示濕度
        GUI_ShowNum(40,3,H/10,2,8,1);
        GUI_ShowString(54,3,".",8,1);         
        GUI_ShowNum(61,3,H%10,1,8,1);
        GUI_ShowString(72,3,"%",8,1);
      }
      else
      {
        // 溫度和濕度數據傳輸出現錯誤
        GUI_ShowString(0,2,"Checksum Error",8,1); 
      }
      PA = 0xFF;
      delay_ms(500);          
    }
}
